/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.manager;

import filenet.vw.api.VWQueueDefinition;
import filenet.vw.apps.manager.VWNodeInformation;
import filenet.vw.apps.manager.resources.VWResource;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWFrameInterface;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.VWWindowAdapter;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.query.VWFilterConditionsPanel;
import filenet.vw.toolkit.utils.query.VWPerformSearchEvent;
import filenet.vw.toolkit.utils.query.VWScopeChangeEvent;
import filenet.vw.toolkit.utils.query.VWSelectColumnsPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class VWQueryDefinitionDialog
extends VWModalDialog
implements IVWFrameInterface,
ActionListener {
    protected boolean m_bComponentsAdjusted = false;
    protected int m_returnValue = -1;
    protected JTabbedPane m_tabbedPane = null;
    protected JButton m_okButton = null;
    protected JButton m_cancelButton = null;
    protected JButton m_helpButton = null;
    protected VWFilterConditionsPanel m_filterConditionsPanel = null;
    protected VWSelectColumnsPanel m_selectColumnsPanel = null;

    public VWQueryDefinitionDialog(Frame parent, VWQueueDefinition vwQueueDef, VWNodeInformation vwNodeInfo) {
        super(parent);
        try {
            this.getContentPane().setLayout(new BorderLayout());
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_queryDefinitionDialogDimensions);
            if (dim == null) {
                this.setSize(700, 300);
            } else {
                this.setSize(dim);
            }
            this.setVisible(false);
            this.setTitle(VWResource.s_queryDefinition);
            this.m_filterConditionsPanel = vwNodeInfo != null && vwNodeInfo.getType() == 2 ? new VWFilterConditionsPanel(VWResource.s_defaultIndex, false) : new VWFilterConditionsPanel(VWResource.s_defaultIndex, true);
            this.m_selectColumnsPanel = new VWSelectColumnsPanel();
            this.m_tabbedPane = new JTabbedPane();
            this.m_tabbedPane.add(this.m_filterConditionsPanel.getDisplayName(), this.m_filterConditionsPanel);
            this.m_tabbedPane.add(this.m_selectColumnsPanel.getDisplayName(), this.m_selectColumnsPanel);
            this.getContentPane().add("Center", this.m_tabbedPane);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_helpButton = new JButton(VWResource.s_helpDots);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout());
            buttonPanel.add(this.m_okButton);
            buttonPanel.add(this.m_cancelButton);
            buttonPanel.add(this.m_helpButton);
            this.getContentPane().add((Component)buttonPanel, "Last");
            this.m_okButton.addActionListener(this);
            this.m_cancelButton.addActionListener(this);
            this.m_helpButton.addActionListener(this);
            this.initControls(vwQueueDef, vwNodeInfo);
            VWWindowAdapter aWindowListener = new VWWindowAdapter(this);
            this.addWindowListener(aWindowListener);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.m_bComponentsAdjusted) {
            return;
        }
        Insets ins = this.getInsets();
        this.setSize(ins.left + ins.right + d.width, ins.top + ins.bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(ins.left, ins.top);
            components[i].setLocation(p);
        }
        this.m_bComponentsAdjusted = true;
    }

    public int getValue() {
        return this.m_returnValue;
    }

    public String getFilterString() {
        if (this.m_filterConditionsPanel != null) {
            return this.m_filterConditionsPanel.getFilterString();
        }
        return null;
    }

    public void getIndexParameters(VWPerformSearchEvent event) {
        if (this.m_filterConditionsPanel != null) {
            this.m_filterConditionsPanel.getIndexParameters(event);
        }
    }

    public String[] getSelectedColumns() {
        if (this.m_selectColumnsPanel != null) {
            return this.m_selectColumnsPanel.getSelectedColumns();
        }
        return null;
    }

    public void windowClosing(WindowEvent event) {
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_cancelButton) {
            this.m_returnValue = 2;
            this.setVisible(false);
        } else if (object == this.m_okButton) {
            this.m_returnValue = 0;
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_General + "bpfwm002.htm");
        }
    }

    protected void initControls(VWQueueDefinition vwQueueDef, VWNodeInformation vwNodeInfo) {
        try {
            VWScopeChangeEvent vwSCEvent = new VWScopeChangeEvent(this);
            if (vwSCEvent == null) {
                return;
            }
            vwSCEvent.setType(2);
            vwSCEvent.setDefinitionObject(vwQueueDef);
            vwSCEvent.setDefaultColumns(vwNodeInfo.getSelectedColumns());
            if (!vwNodeInfo.isTrackerQueue()) {
                String[] tempStringArray = vwSCEvent.getAvailableColumns();
                String[] largerTempStringArray = new String[tempStringArray.length + 1];
                System.arraycopy(tempStringArray, 0, largerTempStringArray, 0, tempStringArray.length);
                largerTempStringArray[largerTempStringArray.length - 1] = "F_StepLabel";
                vwSCEvent.setAvailableColumns(largerTempStringArray);
            }
            this.m_filterConditionsPanel.scopeChanged(vwSCEvent);
            this.m_selectColumnsPanel.scopeChanged(vwSCEvent);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

